// Standard header file for the CCS compiler and PIC16F88
// Geoff Graham,  July 2009

// standard type definitions
typedef     int1            bit;
typedef		signed int8		sint8;
typedef		signed int16	sint16	;
typedef		signed int32	sint24;
typedef		signed int32	sint32;
typedef		unsigned int8	uint8;
typedef		unsigned int16	uint16;
typedef		unsigned int32	uint24;
typedef		unsigned int32	uint32;

#define forever 1
#define OFF     0
#define ON      1

#define uSec(a)	delay_us(a)
#define mSec(a)	delay_ms(a)

#define eeprom_read(a) read_eeprom(a)
#define eeprom_write(a, b) write_eeprom(a, b)

#define WordLoByte(v) make8(v, 0)
#define WordHiByte(v) make8(v, 1)

#use fast_io(A)	
#use fast_io(B)
	
#nolist

// Register and bit definitions used in the the PIC16F88.
// These are intended to make the CCS compiler compatible
// with the definitions used by the Hi-Tech compiler which
// in turn used the naming conventions defined by Microchip

#byte		TMR0		= 0x01
#byte		PCL			= 0x02
#byte		STATUS		= 0x03
#byte		FSR			= 0x04
#byte		PORTA		= 0x05
#byte		PORTB		= 0x06
#byte		PCLATH		= 0x0A
#byte		INTCON		= 0x0B
#byte		PIR1		= 0x0C
#byte		PIR2		= 0x0D
#byte		TMR1L		= 0x0E
#byte		TMR1H		= 0x0F
#byte		T1CON		= 0x10
#byte		TMR2		= 0x11
#byte		T2CON		= 0x12
#byte		SSPBUF		= 0x13
#byte		SSPCON		= 0x14
#byte		CCPR1L		= 0x15
#byte		CCPR1H		= 0x16
#byte		CCP1CON		= 0x17
#byte		RCSTA		= 0x18
#byte		TXREG		= 0x19
#byte		RCREG		= 0x1A
#byte		ADRESH		= 0x1E
#byte		ADCON0		= 0x1F
#byte		OPTION		= 0x81
#byte		TRISA		= 0x85
#byte		TRISB		= 0x86
#byte		PIE1		= 0x8C
#byte		PIE2		= 0x8D
#byte		PCON		= 0x8E
#byte		OSCCON		= 0x8F
#byte		OSCTUNE		= 0x90
#byte		PR2			= 0x92
#byte		SSPADD		= 0x93
#byte		SSPSTAT		= 0x94
#byte		TXSTA		= 0x98
#byte		SPBRG		= 0x99
#byte		ANSEL		= 0x9B
#byte		CMCON		= 0x9C
#byte		CVRCON		= 0x9D
#byte		ADRESL		= 0x9E
#byte		ADCON1		= 0x9F
#byte		WDTCON		= 0x105
#byte		EEDATA		= 0x10C
#byte		EEDAT		= 0x10C
#byte		EEADR		= 0x10D
#byte		EEADRL		= 0x10D
#byte		EEDATH		= 0x10E
#byte		EEADRH		= 0x10F
#byte		EECON1		= 0x18C
#byte		EECON2		= 0x18D


/* Bits used in the STATUS register */
#bit		CARRY		= STATUS.0
#bit		DC			= STATUS.1
#bit		ZERO		= STATUS.2
#bit		PD			= STATUS.3
#bit		TO			= STATUS.4
#bit		RP0			= STATUS.5
#bit		RP1			= STATUS.6
#bit		IRP			= STATUS.7

/* Bits used in the PORTA register */
#bit		RA0			= PORTA.0
#bit		RA1			= PORTA.1
#bit		RA2			= PORTA.2
#bit		RA3			= PORTA.3
#bit		RA4			= PORTA.4
#bit		RA5			= PORTA.5
#bit		RA6			= PORTA.6
#bit		RA7			= PORTA.7

/* Bits used in the PORTB register */
#bit		RB0			= PORTB.0
#bit		RB1			= PORTB.1
#bit		RB2			= PORTB.2
#bit		RB3			= PORTB.3
#bit		RB4			= PORTB.4
#bit		RB5			= PORTB.5
#bit		RB6			= PORTB.6
#bit		RB7			= PORTB.7

/* Bits used in the INTCON register */
#bit		RBIF		= INTCON.0
#bit		INT0IF		= INTCON.1
#bit		TMR0IF		= INTCON.2
#bit		RBIE		= INTCON.3
#bit		INT0IE		= INTCON.4
#bit		TMR0IE		= INTCON.5
#bit		PEIE		= INTCON.6
#bit		GIE			= INTCON.7

/* Bits used in the PIR1 register */
#bit		TMR1IF		= PIR1.0
#bit		TMR2IF		= PIR1.1
#bit		CCP1IF		= PIR1.2
#bit		SSPIF		= PIR1.3
#bit		TXIF		= PIR1.4
#bit		RCIF		= PIR1.5
#bit		ADIF		= PIR1.6

/* Bits used in the PIR2 register */
#bit		EEIF		= PIR2.4
#bit		CMIF		= PIR2.6
#bit		OSFIF		= PIR2.7

/* Bits used in the T1CON register */
#bit		TMR1ON		= T1CON.0
#bit		TMR1CS		= T1CON.1
#bit		T1SYNC		= T1CON.2
#bit		T1OSCEN		= T1CON.3
#bit		T1CKPS0		= T1CON.4
#bit		T1CKPS1		= T1CON.5
#bit		T1RUN		= T1CON.6

/* Bits used in the T2CON register */
#bit		T2CKPS0		= T2CON.0
#bit		T2CKPS1		= T2CON.1
#bit		TMR2ON		= T2CON.2
#bit		TOUTPS0		= T2CON.3
#bit		TOUTPS1		= T2CON.4
#bit		TOUTPS2		= T2CON.5
#bit		TOUTPS3		= T2CON.6

/* Bits used in the SSPCON register */
#bit		SSPM0		= SSPCON.0
#bit		SSPM1		= SSPCON.1
#bit		SSPM2		= SSPCON.2
#bit		SSPM3		= SSPCON.3
#bit		CKP			= SSPCON.4
#bit		SSPEN		= SSPCON.5
#bit		SSPOV		= SSPCON.6
#bit		WCOL		= SSPCON.7

/* Bits used in the CCP1CON register */
#bit		CCP1M0		= CCP1CON.0
#bit		CCP1M1		= CCP1CON.1
#bit		CCP1M2		= CCP1CON.2
#bit		CCP1M3		= CCP1CON.3
#bit		CCP1Y		= CCP1CON.4
#bit		CCP1X		= CCP1CON.5

/* Bits used in the RCSTA register */
#bit		RX9D		= RCSTA.0
#bit		OERR		= RCSTA.1
#bit		FERR		= RCSTA.2
#bit		ADDEN		= RCSTA.3
#bit		CREN		= RCSTA.4
#bit		SREN		= RCSTA.5
#bit		RX9			= RCSTA.6
#bit		SPEN		= RCSTA.7

/* Bits used in the ADCON0 register */
#bit		ADON		= ADCON0.0
#bit		GODONE		= ADCON0.2
#bit		CHS0		= ADCON0.3
#bit		CHS1		= ADCON0.4
#bit		CHS2		= ADCON0.5
#bit		ADCS0		= ADCON0.6
#bit		ADCS1		= ADCON0.7
#bit		ADGO		= ADCON0.2	// alternative

/* Bits used in the OPTION register */
#bit		PS0			= OPTION.0
#bit		PS1			= OPTION.1
#bit		PS2			= OPTION.2
#bit		PSA			= OPTION.3
#bit		T0SE		= OPTION.4
#bit		T0CS		= OPTION.5
#bit		INTEDG		= OPTION.6
#bit		RBPU		= OPTION.7

/* Bits used in the TRISA register */
#bit		TRISA0		= TRISA.0
#bit		TRISA1		= TRISA.1
#bit		TRISA2		= TRISA.2
#bit		TRISA3		= TRISA.3
#bit		TRISA4		= TRISA.4
#bit		TRISA5		= TRISA.5
#bit		TRISA6		= TRISA.6
#bit		TRISA7		= TRISA.7

/* Bits used in the TRISB register */
#bit		TRISB0		= TRISB.0
#bit		TRISB1		= TRISB.1
#bit		TRISB2		= TRISB.2
#bit		TRISB3		= TRISB.3
#bit		TRISB4		= TRISB.4
#bit		TRISB5		= TRISB.5
#bit		TRISB6		= TRISB.6
#bit		TRISB7		= TRISB.7

/* Bits used in the PIE1 register */
#bit		TMR1IE		= PIE1.0
#bit		TMR2IE		= PIE1.1
#bit		CCP1IE		= PIE1.2
#bit		SSPIE		= PIE1.3
#bit		TXIE		= PIE1.4
#bit		RCIE		= PIE1.5
#bit		ADIE		= PIE1.6

/* Bits used in the PIE2 register */
#bit		EEIE		= PIE2.4
#bit		CMIE		= PIE2.6
#bit		OSFIE		= PIE2.7

/* Bits used in the PCON register */
#bit		BOR			= PCON.0
#bit		POR			= PCON.1

/* Bits used in the OSCCON register */
#bit		SCS0		= OSCCON.0
#bit		SCS1		= OSCCON.1
#bit		IOFS		= OSCCON.2
#bit		OSTS		= OSCCON.3
#bit		IRCF0		= OSCCON.4
#bit		IRCF1		= OSCCON.5
#bit		IRCF2		= OSCCON.6

/* Bits used in the OSCTUNE register */
#bit		TUN0		= OSCTUNE.0
#bit		TUN1		= OSCTUNE.1
#bit		TUN2		= OSCTUNE.2
#bit		TUN3		= OSCTUNE.3
#bit		TUN4		= OSCTUNE.4
#bit		TUN5		= OSCTUNE.5

/* Bits used in the SSPSTAT register */
#bit		BF			= SSPSTAT.0
#bit		UA			= SSPSTAT.1
#bit		RW			= SSPSTAT.2
#bit		START		= SSPSTAT.3
#bit		STOP		= SSPSTAT.4
#bit		DA			= SSPSTAT.5
#bit		CKE			= SSPSTAT.6
#bit		SMP			= SSPSTAT.7

/* Bits used in the TXSTA register */
#bit		TX9D		= TXSTA.0
#bit		TRMT		= TXSTA.1
#bit		BRGH		= TXSTA.2
#bit		SYNC		= TXSTA.4
#bit		TXEN		= TXSTA.5
#bit		TX9			= TXSTA.6
#bit		CSRC		= TXSTA.7

/* Bits used in the ANSEL register */
#bit		ANS0		= ANSEL.0
#bit		ANS1		= ANSEL.1
#bit		ANS2		= ANSEL.2
#bit		ANS3		= ANSEL.3
#bit		ANS4		= ANSEL.4
#bit		ANS5		= ANSEL.5
#bit		ANS6		= ANSEL.6

/* Bits used in the CMCON register */
#bit		CM0			= CMCON.0
#bit		CM1			= CMCON.1
#bit		CM2			= CMCON.2
#bit		CIS			= CMCON.3
#bit		C1INV		= CMCON.4
#bit		C2INV		= CMCON.5
//#bit		C1OUT		= CMCON.6
//#bit		C2OUT		= CMCON.7

/* Bits used in the CVRCON register */
#bit		CVR0		= CVRCON.0
#bit		CVR1		= CVRCON.1
#bit		CVR2		= CVRCON.2
#bit		CVR3		= CVRCON.3
#bit		CVRR		= CVRCON.5
#bit		CVROE		= CVRCON.6
#bit		CVREN		= CVRCON.7

/* Bits used in the ADCON1 register */
#bit		VCFG0		= ADCON1.4
#bit		VCFG1		= ADCON1.5
#bit		ADCS2		= ADCON1.6
#bit		ADFM		= ADCON1.7

/* Bits used in the WDTCON register */
#bit		SWDTEN		= WDTCON.0
#bit		WDTPS0		= WDTCON.1
#bit		WDTPS1		= WDTCON.2
#bit		WDTPS2		= WDTCON.3
#bit		WDTPS3		= WDTCON.4

/* Bits used in the EECON1 register */
#bit		RD			= EECON1.0
#bit		WR			= EECON1.1
#bit		WREN		= EECON1.2
#bit		WRERR		= EECON1.3
#bit		FREE		= EECON1.4
#bit		EEPGD		= EECON1.7

#list